import os
from setuptools import find_packages, setup

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-ethgateway',
    version='0.0.1',
    packages=find_packages(),
    include_package_data=True,
    license='GNU GPL License',  # example license
    description='A simple Django app for ethereum.',
    long_description=README,
    url='https://gitlab.bfa.ar/adorda/django-gateway',
    author='Agustin Vicente Dorda Recalde',
    author_email='agustindorda@gmail.com',
    install_requires=[
        'aiohttp==3.5.4',
        'web3==4.6.0'
    ],
    classifiers=[
        'Framework :: Django',
        'Framework :: Django :: 2.1',  # replace "X.Y" as appropriate
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
    ],
)
