import json

from django.core.management.base import BaseCommand
import logging

from gateway.gateway import Gateway, HTTPProviderGenerator

logger = logging.getLogger('cmd-logger')


class Command(BaseCommand):

    def add_arguments(self, parser):
        parser.add_argument('--node_url', help="Node URL", type=str)
        parser.add_argument('--is_poa', help="Is POA network", action='store_false')
        parser.set_defaults(node_url=None, is_poa=False)

    def handle(self, *args, **options):
        try:
            if options['node_url'] is None:
                options['node_url'] = input("Ingrese la url del nodo")

            provider = HTTPProviderGenerator(options['node_url'])
            gateway = Gateway(provider, options['is_poa'])
            self.stdout.write(str(gateway.get_node_accounts()))
        except Exception as e:
            logger.error(e)
