from hexbytes import HexBytes
from web3 import Web3


def is_hex(s):
    try:
        int(s, 16)
        return True
    except Exception:
        return False


class DictToHexBytes:
    def hex_dict(self, dictionary):
        for k, v in dictionary.items():
            if isinstance(v, dict):
                self.hex_dict(dictionary[k])
            elif isinstance(v, list):
                self.hex_list(dictionary[k])
            elif is_hex(v):
                dictionary[k] = HexBytes(v)

    def hex_list(self, sequence):
        i = 0
        while i < len(sequence):
            sequence[i] = HexBytes(sequence[i])
            i = i + 1


def string_to_hex32bytes(some_string):
    return Web3.toHex(some_string).encode()


def hex32bytes_string(some_hex32bytes):
    try:
        return Web3.toText(some_hex32bytes.decode().strip('\\\u0000'))
    except UnicodeDecodeError as ude:
        return some_hex32bytes
