from django.core.exceptions import ValidationError
from django.utils.translation import gettext_lazy as _
from gateway.gateway import AddressValidation


def validate_address(value):
    validator = AddressValidation()
    if not validator.is_valid(value):
        raise ValidationError(_('%(value)s is not a valid address'), params={'value': value})
