<?php

namespace Drupal\tsa2\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class tsa2Form extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'tsa2_form';
  }

   /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
      // Form constructor.
      $form = parent::buildForm($form, $form_state);
      // Default settings.
      $config = $this->config('tsa2.settings');

      // API
      $form['tsa2_api'] = array(
        '#type' => 'textfield',
        '#title' => $this->t('URLs de APIs'),
        '#description' => $this->t('Separados por coma'),
        '#default_value' => $config->get('tsa2_api'),
      );


      $form['mainBody'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Texto Principal'),
        '#default_value' => $config->get('mainBody'),
      );

      $form['lb00'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 0 TSA2 app'),
        '#default_value' => $config->get('lb00'),
      );
      $form['lb01'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 1 TSA2 app'),
        '#default_value' => $config->get('lb01'),
      );
      $form['lb02'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 2 TSA2 app'),
        '#default_value' => $config->get('lb02'),
      );
      $form['lb03'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 3 TSA2 app'),
        '#default_value' => $config->get('lb03'),
      );
      $form['lb04'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 4 TSA2 app'),
        '#default_value' => $config->get('lb04'),
      );
      $form['lb05'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 5 TSA2 app'),
        '#default_value' => $config->get('lb05'),
      );
      $form['lb06'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 6 TSA2 app'),
        '#default_value' => $config->get('lb06'),
      );
      $form['lb07'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 7 TSA2 app'),
        '#default_value' => $config->get('lb07'),
      );
      $form['lb08'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 8 TSA2 app'),
        '#default_value' => $config->get('lb08'),
      );
      $form['lb09'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 9 TSA2 app'),
        '#default_value' => $config->get('lb09'),
      );
      $form['lb10'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 10 TSA2 app'),
        '#default_value' => $config->get('lb10'),
      );
      $form['lb11'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 11 TSA2 app'),
        '#default_value' => $config->get('lb11'),
      );
      $form['lb12'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 12 TSA2 app'),
        '#default_value' => $config->get('lb12'),
      );
      $form['lb13'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 13 TSA2 app'),
        '#default_value' => $config->get('lb13'),
      );
      $form['lb14'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 14 TSA2 app'),
        '#default_value' => $config->get('lb14'),
      );
      $form['lb15'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 15 TSA2 app'),
        '#default_value' => $config->get('lb15'),
      );
      $form['lb16'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 16 TSA2 app'),
        '#default_value' => $config->get('lb16'),
      );
      $form['lb17'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 17 TSA2 app'),
        '#default_value' => $config->get('lb17'),
      );
      $form['lb18'] = array(
        '#type' => 'textarea',
        '#title' => $this->t('Label 18 TSA2 app'),
        '#default_value' => $config->get('lb18'),
      );
  
      return $form;
    }

     /**
   * {@inheritdoc}
   */
    public function validateForm(array &$form, FormStateInterface $form_state) {

    }

    /**
     * {@inheritdoc}
     */
    public function submitForm(array &$form, FormStateInterface $form_state) {
      $config = $this->config('tsa2.settings');
      $config->set('tsa2_api', $form_state->getValue('tsa2_api'));
      $config->set('mainBody', $form_state->getValue('mainBody'));
      $config->set('errorJS', $form_state->getValue('errorJS'));
      $config->set('lb00', $form_state->getValue('lb00'));
      $config->set('lb01', $form_state->getValue('lb01'));
      $config->set('lb02', $form_state->getValue('lb02'));
      $config->set('lb03', $form_state->getValue('lb03'));
      $config->set('lb04', $form_state->getValue('lb04'));
      $config->set('lb05', $form_state->getValue('lb05'));
      $config->set('lb06', $form_state->getValue('lb06'));
      $config->set('lb07', $form_state->getValue('lb07'));
      $config->set('lb08', $form_state->getValue('lb08'));
      $config->set('lb09', $form_state->getValue('lb09'));
      $config->set('lb10', $form_state->getValue('lb10'));
      $config->set('lb11', $form_state->getValue('lb11'));
      $config->set('lb12', $form_state->getValue('lb12'));
      $config->set('lb13', $form_state->getValue('lb13'));
      $config->set('lb14', $form_state->getValue('lb14'));
      $config->set('lb15', $form_state->getValue('lb15'));
      $config->set('lb16', $form_state->getValue('lb16'));
      $config->set('lb17', $form_state->getValue('lb17'));
      $config->set('lb18', $form_state->getValue('lb18'));
      $config->save();
      return parent::submitForm($form, $form_state);
    }

    protected function getEditableConfigNames() {
    return [
        'tsa2.settings',
        ];
    }

}
