<?php

namespace Drupal\tsa2\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class tsa2Form extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'tsa2_form';
  }

   /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Form constructor.
    $form = parent::buildForm($form, $form_state);
    // Default settings.
    $config = $this->config('tsa2.settings');

   // API
   $form['tsa2_api'] = array(
    '#type' => 'textfield',
    '#title' => $this->t('URLs de APIs'),
    '#description' => $this->t('Separados por coma'),
    '#default_value' => $config->get('tsa2_api'),
  );

  $form['mainBody'] = array(
    '#type' => 'textarea',
    '#title' => $this->t('Texto Principal'),
    '#default_value' => ($config->get('mainBody')) ? $config->get('mainBody') : '<p>El servicio de Sello de Tiempo de BFA permite demostrar que el contenido de cualquier documento digital existió en un momento y que desde entonces, no ha cambiado. Al sellar un archivo, cualquiera podrá verificar el día y la hora en que su hash fue almacenado en Blockchain Federal Argentina. Tené en cuenta que el documento seleccionado nunca se sube a la red, garantizando su privacidad.</p><p class="font_small"><a href="https://bfa.ar/sello">Si tenés un archivo con Recibo Digital (.rd) verificalo aquí</a></p>'
  );

  
      return $form;
    }

     /**
   * {@inheritdoc}
   */
    public function validateForm(array &$form, FormStateInterface $form_state) {

    }

    /**
     * {@inheritdoc}
     */
    public function submitForm(array &$form, FormStateInterface $form_state) {
      $config = $this->config('tsa2.settings');
      $config->set('tsa2_api', $form_state->getValue('tsa2_api'));
      $config->set('mainBody', $form_state->getValue('mainBody'));
      $config->save();
      return parent::submitForm($form, $form_state);
    }

    protected function getEditableConfigNames() {
    return [
        'tsa2.settings',
        ];
    }

}
