package bfa

import (
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/crypto"
	"github.com/ethereum/go-ethereum/crypto/sha3"
	"github.com/ethereum/go-ethereum/rlp"
)

func sigHash(header *types.Header) (hash common.Hash) {
	hasher := sha3.NewKeccak256()

	_ = rlp.Encode(hasher, []interface{}{
		header.ParentHash,
		header.UncleHash,
		header.Coinbase,
		header.Root,
		header.TxHash,
		header.ReceiptHash,
		header.Bloom,
		header.Difficulty,
		header.Number,
		header.GasLimit,
		header.GasUsed,
		header.Time,
		header.Extra[:len(header.Extra)-65], // Yes, this will panic if extra is too short
		header.MixDigest,
		header.Nonce,
	})
	hasher.Sum(hash[:0])
	return hash
}

func getSigner(header *types.Header) (address common.Address) {
	if header.Number.Int64() == 0 { // Genesis block has no signers, we return an empty address
		return
	}
	hash := sigHash(header).Bytes()
	pubkey, err := crypto.Ecrecover(hash, header.Extra[len(header.Extra)-65:])
	if err != nil {
		panic(err)
	}
	copy(address[:], crypto.Keccak256(pubkey[1:])[12:])
	return
}
