package util

import (
	"encoding/hex"
	"encoding/json"
	"fmt"
	"github.com/ethereum/go-ethereum/common"
	"log"
	"os"
	"runtime"
	"strconv"
)

func Contains(slice []string, s string) bool {
	for _, x := range slice {
		if x == s {
			return true
		}
	}
	return false
}


func Error(format string, args ...interface{}) {
	_, _ = fmt.Fprintf(os.Stderr, format, args...)
	os.Exit(1)
}

func Ensure(condition bool, format string, args ...interface{}) {
	if !condition {
		Error(format, args...)
	}
}

func Check(err error) {
	Ensure(err == nil, "%v\n", err)
}

func BytesToHex(b []byte) string {
	return fmt.Sprintf("0x%02x", b)
}

func Int64ToHex(n int64) string {
	return "0x" + strconv.FormatInt(n, 16)
}

func Require(condition bool, msg string) {
	if !condition {
		ptr, _, _, _ := runtime.Caller(1)
		log.Panicf("%v in %v", msg, runtime.FuncForPC(ptr).Name())
	}
}

func PrintDebug(prefix, suffix string) {
	ptr, _, _, _ := runtime.Caller(1)
	fmt.Printf("%v: %v%v\n", prefix, runtime.FuncForPC(ptr).Name(), suffix)
}

func Min(a, b int64) int64 {
	if a < b {
		return a
	}
	return b
}

func Max(a, b int64) int64 {
	if a > b {
		return a
	}
	return b
}

func PrintJson(s interface{}) {
	v, err := json.MarshalIndent(s, "", "  ")
	Check(err)
	fmt.Println(string(v))
	return
}

func IsAddress(address string) bool {
	bytes, err := hex.DecodeString(address[2:])
	return err == nil && len(bytes) == common.AddressLength
}
