package util

import (
	"strings"
	"testing"
)

var (
	addresses = map[string]string{
		"ValidReal":               "0x46991ada2a2544468eb3673524641bf293f23ccc",
		"ValidSeq":                "0x000102030405060708090a0b0c0d0e0f10111213",
		"ValidZero":               "0x0000000000000000000000000000000000000000",
		"InvalidNoPrefix":         "0046991ada2a2544468eb3673524641bf293f23ccc",
		"InvalidEmpty":            "",
		"InvalidLengthVeryShort":  "0x",
		"InvalidLengthShort":      "0x46991ada2a2544468eb3673524641bf293f23cc",
		"InvalidLengthLong":       "0x46991ada2a2544468eb3673524641bf293f23ccc00",
		"InvalidNoHexAtBeginning": "0xx6991ada2a2544468eb3673524641bf293f23ccc",
		"InvalidNoHexAtEnd":       "0x46991ada2a2544468eb3673524641bf293f23ccx",
	}
)

func TestValidAddress(t *testing.T) {
	for name, address := range addresses {
		t.Run(name, func(t *testing.T) {
			if IsAddress(address) != strings.HasPrefix(name, "Valid") {
				t.Fail()
			}
		})
	}
}

func BenchmarkIsAddressTrue(b *testing.B) {
	for name, address := range addresses {
		b.Run(name, func(b *testing.B) {
			for i := 0; i < b.N; i++ {
				_ = IsAddress(address)
			}
		})
	}
}
