/*
Copyright 2019 de la Dirección General de Sistemas Informáticos – Secretaría Legal y Técnica - Nación.

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see http://www.gnu.org/licenses/
*/
var tsa_api = 'https://tsaapi.bfa.ar/api/tsa/';
var loader_gif = 'lib/images/loader.svg';
var ots_api = '';
var deadline_date = new Date('2018-09-03 00:00:00');
var current_date = new Date();
var whash = window.location.hash;
var currentTab = whash.substring(5, 6);

$(function () {
    whash && $('ul.nav a[href="' + whash + '"]').tab('show');
    $('.nav-tabs a').click(function (e) {
        $(this).tab('show');
        var scrollmem = $('body').scrollTop() || $('html').scrollTop();
        whash = this.hash;
        currentTab = whash.substring(5, 6);
        window.location.hash = whash;
        $('html,body').scrollTop(scrollmem);
    });


    for (let i = 1; i < 4; i++) {
        $('#selectOriginal_' + i+', #selectOriginalArea_' + i).on('click', function () {
            $('#fileUploadOriginal_' + i).click();
            return false;
        });
        if (i == 1) {
            $('#fileUploadOriginal_' + i).change(
                function () {
                    var file = $(this).prop('files')[0];
                    stamp(file);
                }
            );
        } else {
            $('#fileUploadOriginal_' + i).change(
                function () {
                    var file = $(this).prop('files')[0];
                    original_file_check(file);
                }
            );
            $('#selectRecibo_' + i+', #selectReciboArea_' + i).on('click', function () {
                $('#fileUploadRecibo_' + i).click();
                return false;
            });
            $('#fileUploadRecibo_' + i).change(
                function () {
                    var file = $(this).prop('files')[0];
                    ots_check(file);
                }
            );
        }
    }

});

function allowDrop(e) {
    e.preventDefault();
}

function dropStamp(e) {
    e.preventDefault();
    var file = e.dataTransfer.items[0].getAsFile();
    stamp(file);
}

function stamp(file) {
    var reader = new FileReader();
    reader.readAsArrayBuffer(file, "UTF-8")
    reader.onload = function (evt) {
        var file_contents = evt.target.result;

        var hash = sha256.create();
        hash.update(file_contents);
        var file_hash = hash.hex();

        $('#originalInfo_1').html('<p>Nombre del archivo: <b>' + file.name + '</b></p><p>Hash del archivo: <b><span class="hash">' + file_hash + '</span></b></p>');
        $('#selectOriginal_1').html('Seleccioná otro archivo <span class="sr-only">para marcar</span>');


        $.ajax({
            url: tsa_api + "stamp/",
            type: "POST",
            data: {
                "file_hash": file_hash
            },
            dataType: "json",
            success: function (response) {


                var ots = ' {"file_hash": "' + file_hash + '", "rd": "' + response.temporary_ots + '"}';


                var saveData = (function () {
                    var a = document.createElement("a");
                    document.body.appendChild(a);
                    a.style = "display: none";
                    return function (data, fileName) {
                        var json = JSON.stringify(data),
                            blob = new Blob([json], {
                                type: "octet/stream"
                            }),
                            url = window.URL.createObjectURL(blob);
                        a.href = url;
                        a.download = fileName;
                        a.click();
                        window.URL.revokeObjectURL(url);
                    };
                }());

                var data = response.temporary_rd
                fileName = file.name + ".rd.temp";

                saveData(data, fileName);

            }
        });
    }
}


function verify_bfa(ots) {

    var pending = false;
    var message = '';

    $('#response_' + currentTab).removeClass();

    $.ajax({
        url: tsa_api + "verify/",
        type: "POST",
        data: {
            "file_hash": ots.file_hash,
            "rd": ots.rd
        },
        dataType: "json",
        success: function (response) {

            if (response.status == 'success') {
                icon = 'glyphicon-ok';
                st = 'alert alert-success';
                response_messages = response.messages.replace(ots.file_hash, $('#hidden_original_file_name_' + currentTab).val());
            } else if (response.status == 'pending') {
                pending = true;
                icon = 'glyphicon-time';
                st = 'alert alert-warning';
                response_messages = response.messages;
            } else {
                icon = 'glyphicon-remove';
                st = 'alert alert-danger';
                response_messages = response.messages;
            }

            message = '<span class="glyphicon ' + icon + '" aria-hidden="true"></span> ' + response_messages;


            $('#response_' + currentTab).addClass(st);
            $('#response_' + currentTab).html(message);

            if (!pending) {
                var saveData = (function () {
                    var a = document.createElement("a");
                    document.body.appendChild(a);
                    a.style = "display: none";
                    return function (data, fileName) {
                        var json = JSON.stringify(data),
                            blob = new Blob([json], {
                                type: "octet/stream"
                            }),
                            url = window.URL.createObjectURL(blob);
                        a.href = url;
                        a.download = fileName;
                        a.click();
                        window.URL.revokeObjectURL(url);
                    };
                }());

                var data = response.permanent_rd;
                fileName = $('#hidden_original_file_name_' + currentTab).val() + ".rd";

                if (currentTab == '2') {
                    ms = 'Seleccioná otro archivo <span class="sr-only">.rd.temp</span>';
                } else if (currentTab == '3') {
                    ms = 'Seleccioná otro archivo <span class="sr-only">.rd</span>';
                }

                $('#selectRecibo_' + currentTab).html(ms);
                $('#reciboInstructions_' + currentTab).hide();

                if ($('#reciboInfo_' + currentTab).html().includes('.temp')) {
                    saveData(data, fileName);
                }

            }


        },
        error: function (jqXHR, textStatus, errorThrown) {

            responseText = 'El recibo digital no corresponde al documento seleccionado.';

            if (errorThrown == 'timeout') {
                responseText = 'No se pudo conectar a Blockchain Federal Argentina';
            }
            if (whash == '#certificado-tab') {
                rp_id = "#response_cert";
            } else {
                rp_id = "#response";
            }
            $('#response_' + currentTab).html('<span class="glyphicon glyphicon-remove" aria-hidden="true"></span> ' + responseText);
            $('#response_' + currentTab).addClass('alert alert-danger');

        },
        timeout: 5000

    });
}


function dropOriginalFile(e) {
    e.preventDefault();
    var file = e.dataTransfer.items[0].getAsFile();
    original_file_check(file);
}


function original_file_check(file) {
    $('#response_' + currentTab).html('');
    $('#response_' + currentTab).removeClass();
    $('#reciboInfo_' + currentTab).html('');
    $('#reciboInstructions_' + currentTab).show();
    var reader = new FileReader();
    reader.readAsArrayBuffer(file, "UTF-8")
    reader.onload = function (evt) {
        var file_contents = evt.target.result;

        var hash = sha256.create();
        hash.update(file_contents);
        var file_hash = hash.hex();

        $('#hidden_original_file_hash_' + currentTab).val(file_hash);
        $('#hidden_original_file_name_' + currentTab).val(file.name);

        $('#originalInfo_' + currentTab).html('<p>Nombre del archivo: <b>' + file.name + '</b></p><p>Hash del archivo: <b><span class="hash">' + file_hash + '</span></b></p>');
        $('#selectOriginal_' + currentTab).html('Seleccioná otro archivo <span class="sr-only">original</span>');
    };
}

function dropOTSFile(e) {
    e.preventDefault();
    var file = e.dataTransfer.items[0].getAsFile();
    ots_check(file);
}

function ots_check(file) {
    $('#response_' + currentTab).html('');
    $('#response_' + currentTab).removeClass();
    var file_contents = '';
    var file_hash = $('#hidden_original_file_hash_' + currentTab).val();
    if (file_hash == '') {
        $('#response_' + currentTab).html('<span class="glyphicon glyphicon-remove" aria-hidden="true"></span> Debe ingresar el archivo original');
        $('#response_' + currentTab).addClass('alert alert-danger');
        return;
    }
    var reader = new FileReader();
    reader.readAsText(file, "UTF-8")
    reader.onload = function (evt) {
        file_contents = evt.target.result;
        $('#reciboInstructions_' + currentTab).hide();
        $('#reciboInfo_' + currentTab).html(file.name);

        var ots = {
            "file_hash": file_hash,
            "rd": file_contents
        }

        verify_bfa(ots);
    };
}